(function($) {  
    $(document).ready(function() {
        var main = $('#cs_la_main');
        var side = $('.cs_la_sub');
        var wrapper = $('.cs_la_sub_menu');
  
        var w = $(window);  
        var wrapperHeight = wrapper.outerHeight() + 160;  
        var wrapperTop = wrapper.offset().top;  
        var sideLeft = side.offset().left;  
  
        var sideMargin = {  
            top: side.css('margin-top') ? side.css('margin-top') : 0,  
            right: side.css('margin-right') ? side.css('margin-right') : 0,  
            bottom: side.css('margin-bottom') ? side.css('margin-bottom') : 0,  
            left: side.css('margin-left') ? side.css('margin-left') : 0  
        };  
  
        var winLeft;  
        var pos;  
  
        var scrollAdjust = function() {  
            sideHeight = side.outerHeight();  
            mainHeight = main.outerHeight();  
            mainCc = main.offset().top + mainHeight;  
            var winTop = w.scrollTop() + 160;  
            winLeft = w.scrollLeft();  
            var winHeight = w.height();  
            var nf = (winTop > wrapperTop) && (mainHeight > sideHeight) ? true : false;  
            pos = !nf ? 'static' : (winTop - 160 + wrapperHeight) > mainCc ? 'absolute' : 'fixed';  
            if (pos === 'fixed') {  
                side.css({  
                    position: pos,  
                    top: '',  
                    bottom: winHeight - wrapperHeight,  
                    left: sideLeft - winLeft,  
                    margin: 0  
                });  
  
            } else if (pos === 'absolute') {  
                side.css({  
                    position: pos,  
                    top: mainCc - sideHeight,  
                    bottom: '',  
                    left: sideLeft,  
                    margin: 0  
                });  
  
            } else {  
                side.css({  
                    position: pos,  
                    marginTop: sideMargin.top,  
                    marginRight: sideMargin.right,  
                    marginBottom: sideMargin.bottom,  
                    marginLeft: sideMargin.left  
                });  
            }  
        };  
  
        var resizeAdjust = function() {  
            side.css({  
                position:'static',  
                marginTop: sideMargin.top,  
                marginRight: sideMargin.right,  
                marginBottom: sideMargin.bottom,  
                marginLeft: sideMargin.left  
            });  
            sideLeft = side.offset().left;  
            winLeft = w.scrollLeft();  
            if (pos === 'fixed') {  
                side.css({  
                    position: pos,  
                    left: sideLeft - winLeft,  
                    margin: 0  
                });  
  
            } else if (pos === 'absolute') {  
                side.css({  
                    position: pos,  
                    left: sideLeft,  
                    margin: 0  
                });  
            }  
        };  
        w.on('load', scrollAdjust);  
        w.on('scroll', scrollAdjust);  
        w.on('resize', resizeAdjust);  
    });  
})(jQuery);  